<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class EnsureLoginFlow
{
    public function handle(Request $request, Closure $next)
    {
        if (! session()->has('login_user_id')) {
            return redirect()->route('login')
                ->with('error', 'Please login first.');
        }

        return $next($request);
    }
}
