<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class EnsureSignupFlow
{
    public function handle(Request $request, Closure $next)
    {
        if (! session()->has('signup_user_id')) {
            return redirect()->route('signup')
                ->with('error', 'Invalid signup flow.');
        }

        return $next($request);
    }
}
