<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Traits\ZohoCrmTrait;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;

class Uploadpaymentfile implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    use ZohoCrmTrait;

    protected $dealId;
    protected $path;

    public function __construct($dealId, $path)
    {
        $this->dealId = $dealId;
        $this->path   = $path;
    }

    public function handle()
    {
        $module = 'Deals';

        $fullPath = Storage::disk('local')->path($this->path);

        if (!file_exists($fullPath)) {
            Log::error('Receipt file not found', ['path' => $fullPath]);
            return;
        }

        /** Upload file to Zoho */
        $photoResponse = $this->updateZohoCrmRecordPhoto(
            $module,
            $this->dealId,
            $fullPath
        );

        Log::info('Zoho upload response', ['response' => $photoResponse]);

        $fileId = null;

        if (isset($photoResponse['response'])) {
            $decoded = json_decode($photoResponse['response'], true);

            if (
                isset($decoded['data'][0]['code']) &&
                $decoded['data'][0]['code'] === 'SUCCESS'
            ) {
                $fileId = $decoded['data'][0]['details']['id'] ?? null;
            }
        }

        if (! $fileId) {
            Log::error('Zoho file upload failed', ['dealId' => $this->dealId]);
            return;
        }

        /** Attach file to Deal field */
        $payload = [
            'data' => [
                [
                    'id' => $this->dealId,
                    'Payment_SS' => [
                        [
                            'File_Id__s' => $fileId
                        ]
                    ]
                ]
            ]
        ];

        $response = $this->updateZohoCrmRecord(
            'Deals',
            $this->dealId,
            $payload
        );

        Log::info('Payment attachment response', ['response' => $response]);
    }
}