<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CompanyDefaultDetail extends Model
{
    protected $table = 'default_details';

    protected $fillable = [
        'company_info_id',
        'amount_involved',
        'duration_of_default',
        'statutory_dues_status',
        'debentures_interest_status',
        'deposits_interest_status',
        'loans_interest_status',
        'name',
        'address',
        'designation',
        'phone_number',
        'email',
    ];

    public function company()
    {
        return $this->belongsTo(CompanyGeneralInfo::class, 'company_info_id');
    }
}
