<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CompanyDirector extends Model
{
    protected $table = 'directors_management';

    protected $fillable = [
        'company_info_id',
        'serial_no',
        'name',
        'address',
        'din',
        'occupation',
    ];

    public function company()
    {
        return $this->belongsTo(CompanyGeneralInfo::class, 'company_info_id');
    }
}
