<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Psy\CodeCleaner\FinalClassPass;

class CompanyGeneralInfo extends Model
{
    use HasFactory;

    protected $table = 'company_general_infos'; // change if table name is different

    protected $primaryKey = 'id';

    protected $fillable = [
        'form_number',
        'company_name',
        'registered_office_address',
        'corporate_office_address',
        'email_id',
        'website',
        'contact_number',
        'date_of_incorporation',
        'business_activities',
        'subsidiaries_details',
        'branches_units_details',
        'management_brief',
        'risk_perception',
        'registrar_of_issue',
        'valuation_agency',
        'auditors',
        'annual_filing_default',
    ];

    protected $casts = [
        'date_of_incorporation' => 'date',
    ];

    public function directors()
{
    return $this->hasMany(CompanyDirector::class, 'company_info_id')
                ->orderBy('serial_no');
}

public function defaultDetails()
{
    return $this->hasOne(CompanyDefaultDetail::class, 'company_info_id');
}

public function financialdata()
{
    return $this->hasMany(FinancialCondition::class, 'company_info_id');
}

public function offerParticular()
{
    return $this->hasOne(OfferParticular::class,'company_info_id');
}
public function ProposedAllottes()
{
    return $this->hasMany(ProposedAllottes::class,'company_info_id','id')->orderBy('serial_no');
}

public function accountingPolicy()
{
    return $this->hasOne(AccountingPolicy::class,'company_info_id');
}

public function capitalStructure()
{
    return $this->hasMany(CapitalStructure::class,'company_info_id');
}

public function cashFlowStatements()
{
    return $this->hasMany(CashFlowStatements::class,'company_info_id');
}

public function companyDirectorRemuneration()
{
    return $this->hasMany(CompanyDirectorRemuneration::class,'company_info_id');
}

public function disclosures()
{
    return $this->hasOne(Disclosures::class,'company_info_id');
}

public function existingShareCapital()
{
    return $this->hasMany(ExistingShareCapital::class,'company_info_id');
}

public function shareholdingpattern()
{
    return $this->hasMany(ShareHoldingPattern::class,'company_info_id');
}


public function financialSummary()
{
    return $this->hasMany(FinancialSummary::class,'company_info_id');
}

public function paymentMode()
{
    return $this->hasOne(PaymentMode::class,'company_info_id');
}

public function profitTaxProvision()
{
    return $this->hasMany(ProfitTaxProvision::class,'company_info_id');
}
public function Financialsummarydata()
{
    return $this->hasOne(FinancialSummaryData::class,'company_info_id');
}

// public function user()
// {
//     return $this->hasMany(User::class,'company_info_id');
// }



}
