<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Disclosures extends Model
{
    use HasFactory;

    // Table name
    protected $table = 'disclosures';

    // Primary key
    protected $primaryKey = 'id';

    // Only created_at exists
    public $timestamps = false;

    // Mass assignable fields
    protected $fillable = [
        'company_info_id',
        'directors_interest_details',
        'litigation_details',
        'related_party_transactions',
        'auditors_remarks',
        'inquiries_investigations',
        'material_frauds',
        'created_at',
    ];

    // Casts
    protected $casts = [
        'company_info_id' => 'integer',
        'created_at'      => 'datetime',
    ];

    // Relationship
    public function companyInfo()
    {
        return $this->belongsTo(CompanyGeneralInfo::class, 'company_info_id');
    }
}
