<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ExistingShareCapital extends Model
{
    use HasFactory;

    // Table name
    protected $table = 'existing_share_capital';

    // Primary key
    protected $primaryKey = 'id';

    // Only created_at exists
    public $timestamps = false;

    // Mass assignable fields
    protected $fillable = [
        'company_info_id',
        'details',
        'date_of_allotment',
        'number_of_equity_shares',
        'face_value',
        'premium',
        'total_amount',
        'form_of_consideration',
        'created_at',
    ];

    // Casts
    protected $casts = [
        'company_info_id'           => 'integer',
        'date_of_allotment'         => 'date',
        'number_of_equity_shares'   => 'integer',
        'face_value'                => 'decimal:2',
        'premium'                   => 'decimal:2',
        'total_amount'              => 'decimal:2',
        'created_at'                => 'datetime',
    ];

    // Relationship
    public function companyInfo()
    {
        return $this->belongsTo(CompanyGeneralInfo::class, 'company_info_id');
    }
}
