<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FinancialSummary extends Model
{
    use HasFactory;

    // Table name
    protected $table = 'financial_summary';

    // Primary key
    protected $primaryKey = 'id';

    // Only created_at exists
    public $timestamps = false;

    // Mass assignable fields
    protected $fillable = [
        'company_info_id',
        'financial_year',
        'total_revenue',
        'profit_before_tax',
        'tax_expense',
        'profit_after_tax',
        'balance_brought_forward',
        'surplus_deficit',
        'created_at',
    ];

    // Casts
    protected $casts = [
        'company_info_id'           => 'integer',
        'total_revenue'             => 'decimal:2',
        'profit_before_tax'         => 'decimal:2',
        'tax_expense'               => 'decimal:2',
        'profit_after_tax'          => 'decimal:2',
        'balance_brought_forward'   => 'decimal:2',
        'surplus_deficit'           => 'decimal:2',
        'created_at'                => 'datetime',
    ];

    // Relationship
    public function companyInfo()
    {
        return $this->belongsTo(CompanyGeneralInfo::class, 'company_info_id');
    }
}
