<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProposedAllottes extends Model
{
    protected $table = 'proposed_allottees'; // adjust if table name differs

    protected $fillable = [
        'company_info_id',
        'serial_no',
        'name',
        'equity_shares_count',
        'percentage',
    ];

    protected $casts = [
        'equity_shares_count' => 'integer',
        'percentage'          => 'decimal:2',
    ];

    public $timestamps = false;

    /**
     * Each shareholding row belongs to one company
     */
    public function company()
    {
        return $this->belongsTo(
            CompanyGeneralInfo::class,
            'company_info_id',
            'id'
        );
    }
}
