<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\DB;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
   protected $fillable = [
    'name',
    'email',
    'password',
    'first_name',
    'last_name',
    'mobile',
    'otp_sms',
    'referral_code',
    'otp_email',
    'passcode',
    'status',
    'smsotp_created_at',
    'emailotp_created_at',
    'google_id',
    'contactzohoid',
    'aadharclientid',
    'usertype',
    'Account_Id',
    'security_type',
    'withdrawl_security_type'
   
];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
    
     public static function generateAccountId()
{
    return DB::transaction(function () {
        $lastAccount = DB::table('users')
            ->lockForUpdate()
            ->whereNotNull('Account_Id')
            ->orderByDesc('id')
            ->value('Account_Id');

        $number = $lastAccount
            ? intval(substr($lastAccount, -8)) + 1
            : 1;

        return 'BeniSS-I-' . str_pad($number, 8, '0', STR_PAD_LEFT);
    });
}
}
