<?php

namespace App\Repositories;

use App\Models\User;
use Illuminate\Database\Eloquent\Collection;

class UserRepository
{
    public function all(): Collection
    {
        return User::all();
    }

    public function find(int $id): ?User
    {
        return User::find($id);
    }

    public function create(array $data): User
    {
        return User::create($data);
    }

    public function update(int $id, array $data): bool
    {
        $user = User::find($id);
        if (! $user) return false;

        return $user->update($data);
    }

    public function delete(int $id): bool
    {
        $user = User::find($id);
        if (! $user) return false;

        return $user->delete();
    }



    public function updateOtp(int $userId, int $otp): void
    {
        User::where('id', $userId)->update([
            'otp_sms' => $otp,
            'smsotp_created_at' => now(),
        ]);
    }

    public function findByMobile(string $mobile): ?User
    {
        return User::where('mobile', $mobile)->first();
    }

    public function findByEmail(string $email): ?User
    {
        return User::where('email', $email)->first();
    }

    // public function findByEmail(string $email): ?User
    // {
    //     return User::where('email', $email)->first();
    // }

    public function updatePasscode(int $userId, string $hashedPasscode): void
{
    User::where('id', $userId)->update([
        'passcode' => $hashedPasscode,
        'status' => '1'
    ]);
}
}
