<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
       $middleware->alias([
        'signup.flow' => \App\Http\Middleware\EnsureSignupFlow::class,
        'login.flow'  => \App\Http\Middleware\EnsureLoginFlow::class,
        'auth.user'   => \App\Http\Middleware\EnsureAuthenticatedUser::class,
        'no.back' => \App\Http\Middleware\PreventBackHistory::class,
        'auto.logout' => \App\Http\Middleware\AutoLogoutOnInactivity::class,
         'kyc.step' => \App\Http\Middleware\CheckKycStep::class,
        
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
