<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            
            // New fields you requested
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('mobile')->nullable();
            $table->string('otp_sms')->nullable();
            $table->string('referral_code')->nullable();
            $table->string('otp_email')->nullable();
            $table->string('passcode')->nullable(); // If sensitive, hash later
            $table->string('gender')->nullable();   // male/female/other
            $table->date('dob')->nullable();
            $table->string('marital_status')->nullable();     // single/married/etc
            $table->string('annual_income')->nullable();      // or decimal if needed
            $table->string('occupation')->nullable();
            
            // preference for account settings -> JSON type recommended
            $table->json('preferences')->nullable();
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'first_name',
                'last_name',
                'mobile',
                'otp_sms',
                'referral_code',
                'otp_email',
                'passcode',
                'gender',
                'dob',
                'marital_status',
                'annual_income',
                'occupation',
                'preferences',
            ]);
        });
    }
};

