<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>BeniSS Global - Link Bank Account</title>
    @include('head')
</head>
<body>

@include('header-user')

<section class="hero-section">
    <div class="container">
        <div class="row g-4 align-items-center">
            <div class="col-lg-2"></div>

            <div class="col-lg-8">

                <div class="signup-card">

                    <img src="{{ asset('assets/login-otp-3.png') }}" style="width: 100%">

                    <h4 class="mb-4 text-center" style="margin: 30px 0 !important;">
                        Link Your Bank Account
                    </h4>

                    <form action="{{ route('savebankdetail') }}" method="POST">
                        @csrf

                        {{-- Validation Errors --}}
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        {{-- API Failure Error --}}
                        @if(session('error'))
                            <div class="alert alert-danger">
                                {{ session('error') }}
                            </div>
                        @endif

                        <!-- IFSC & Bank -->
                        <div class="row g-3 mb-3">
                            <div class="col-md-6">
                                <input type="text"
                                       name="ifsc"
                                       placeholder="IFSC"
                                       value="{{ old('ifsc') }}"
                                       class="form-control @error('ifsc') is-invalid @enderror">
                                @error('ifsc')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <input type="text"
                                       name="bank"
                                       placeholder="Bank"
                                       value="{{ old('bank') }}"
                                       class="form-control @error('bank') is-invalid @enderror">
                                @error('bank')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- MICR & Branch -->
                        <div class="row g-3 mb-3">
                            <div class="col-md-6">
                                <input type="text"
                                       name="micr"
                                       placeholder="MICR"
                                       value="{{ old('micr') }}"
                                       class="form-control @error('micr') is-invalid @enderror">
                                @error('micr')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <input type="text"
                                       name="branch"
                                       placeholder="Branch"
                                       value="{{ old('branch') }}"
                                       class="form-control @error('branch') is-invalid @enderror">
                                @error('branch')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Account Number & Confirm -->
                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <input type="text"
                                       name="account_number"
                                       placeholder="Account Number"
                                       value="{{ old('account_number') }}"
                                       class="form-control @error('account_number') is-invalid @enderror">
                                @error('account_number')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <input type="text"
                                       name="cnfrm_account_number"
                                       placeholder="Confirm Account Number"
                                       value="{{ old('cnfrm_account_number') }}"
                                       class="form-control @error('cnfrm_account_number') is-invalid @enderror">
                                @error('cnfrm_account_number')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Buttons -->
                        <div class="row">
                            <div class="col-md-6">
                                <button type="button" class="btn btn-secondary w-100">
                                    Back
                                </button>
                            </div>

                            <div class="col-md-6">
                                <button type="submit" class="btn btn-primary w-100">
                                    Continue
                                </button>
                            </div>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>
</section>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>