<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Transition Details - PDF</title>

<style>

/* PDF PAGE SETUP */
@page {
    size: A4;
    margin: 20mm 15mm;
}

body {
    margin: 0;
    font-family: Arial, sans-serif;
    -webkit-print-color-adjust: exact;
    print-color-adjust: exact;
    font-size: 14px;
    color: #333;
}

/* CONTAINER */
.page {
    width: 100%;
}

/* HEADER */
.header {
    background: #fff2d9;
    padding: 20px 25px;
    overflow: hidden;
}

.logo-section {
    float: left;
}

.logo {
    width: 55px;
    vertical-align: middle;
}

.company-name {
    font-size: 20px;
    font-weight: 600;
    color: #0c2c3d;
    display: inline-block;
    vertical-align: middle;
    margin-left: 10px;
}

.title {
    float: right;
    font-size: 26px;
    font-weight: bold;
    color: #0c2c3d;
    margin-top: 10px;
}

/* CLEAR FLOAT */
.clearfix::after {
    content: "";
    display: block;
    clear: both;
}

/* DETAILS CARD */
.details-card {
    background: #e6e6e6;
    margin-top: 25px;
    padding: 20px 25px;
    border-radius: 8px;
    page-break-inside: avoid;
}

.details-grid {
    width: 100%;
    border-collapse: collapse;
}

.details-grid td {
    padding: 8px 5px;
    font-size: 14px;
}

.label {
    font-weight: 600;
    color: #2f3e4e;
    width: 180px;
}

/* SECTION TITLE */
.section-title {
    background: #d9d9d9;
    text-align: center;
    font-size: 22px;
    font-weight: 700;
    padding: 10px;
    margin-top: 30px;
    page-break-after: avoid;
}

/* TABLE */
.transaction-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 15px;
    font-size: 13px;
}

.transaction-table thead {
    display: table-header-group; /* repeat header on page break */
}

.transaction-table th {
    text-align: left;
    padding: 8px;
    border-bottom: 2px solid #3c4a5c;
    background: #f2f2f2;
}

.transaction-table td {
    padding: 8px;
    border-bottom: 1px solid #ccc;
}

.transaction-table tr {
    page-break-inside: avoid;
}

/* FOOTER */
.footer {
    background: #063b4c;
    text-align: center;
    padding: 15px;
    margin-top: 30px;
    color: #fff;
    font-size: 13px;
    page-break-inside: avoid;
}

</style>
</head>

<body>

<div class="page">

    <!-- HEADER -->
    <div class="header clearfix" style="display:flex; align-items:center; justify-content:space-between;">
        <div class="logo-section" style="display:flex; align-items:center; justify-content:left; vertical-align:center;">
           <img src="{{ public_path('assets/Beniss_Global.png') }}" class="logo">
            <span class="company-name">BeniSS Global Limited</span>
        </div>
        <div class="title">Transition Details</div>
    </div>

    <!-- DETAILS CARD -->
    <div class="details-card">
        <table class="details-grid">
            <tr>
                <td class="label">Unique Client Code :</td>
                <td style="text-align:left;">{{ $contact['Account_Id'] ?? '-' }}</td>
                <td class="label">Client Name :</td>
                <td>{{ ($contact['First_Name'] ?? '') . ' ' . ($contact['Last_Name'] ?? '') }}</td>
            </tr>
            <tr>
                <td class="label">Father Name :</td>
                <td>{{ $contact['Father_s_Name'] ?? '-' }}</td>
                 <td class="label">PAN Number :</td>
                <td>{{ $contact['PAN'] ?? '-' }}</td>
               
            </tr>
        
        
            <tr>
               
                <td class="label">Generated on :</td>
                <td>{{ now()->format('d/m/Y H:i:s') }}</td>
            </tr>
        </table>
    </div>

    <!-- SECTION TITLE -->
    <div class="section-title">
        Stage History
    </div>

    <!-- TABLE -->
    <table class="transaction-table">
        <thead>
            <tr>
                <th>Transaction Date</th>
                <th>Settlement Date</th>
                <th>Security Type</th>
                <th>Narration</th>
                <th>Debit (Rs.)</th>
                <th>Credit (Rs.)</th>
                <th>Balance (Rs.)</th>
            </tr>
        </thead>
         <tbody>
        @forelse($transactions as $transaction)
        <tr>
            <td>{{ \Carbon\Carbon::parse($transaction->transaction_date)->format('d-m-Y') }}</td>
            <td>{{ \Carbon\Carbon::parse($transaction->settlement_date)->format('d-m-Y') }}</td>
            <td>{{ $transaction->security_type }}</td>
            <td>{{ $transaction->narration }}</td>
            <td class="text-right">{{ number_format($transaction->debit, 2) }}</td>
            <td class="text-right">{{ number_format($transaction->credit, 2) }}</td>
            <td class="text-right">{{ number_format($transaction->balance, 2) }}</td>
        </tr>
        @empty
        <tr>
            <td colspan="7">No transactions found</td>
        </tr>
        @endforelse
    </tbody>
    </table>

    <!-- FOOTER -->
    <div class="footer">
        ISO 27001 Certified
    </div>

</div>

</body>
</html>