<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\SignupController;
use App\Http\Controllers\UserDetailsController;
use App\Http\Controllers\CheckUserExistence;
use App\Http\Controllers\InvestmentFormController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Storage;




Route::get('/', [LoginController::class, 'login'])->name('login');
Route::post('/loginpasscode', [LoginController::class, 'loginpasscode'])->name('loginpasscode')
    ->middleware('throttle:5,1');

Route::middleware('login.flow')->group(function () {
Route::get('/passcodepageenter', [LoginController::class, 'passcodepage'])->name('passcodepageenter');
Route::post('/submitpasscode', [LoginController::class, 'submitpasscode'])->name('submitpasscode');

});

Route::get('/forgetpasscodepage', [LoginController::class, 'forgetpasscodepage'])->name('forgetpasscodepage');
Route::get('/forgetpasscode', [LoginController::class, 'forgetpasscode'])->name('forgetpasscode');
Route::post('/verifyotpforget', [LoginController::class, 'verifyotp'])->name('verifyotpforget');
Route::get('/updatepasscodepage', [LoginController::class, 'updatepasscodepage'])->name('updatepasscodepage');
Route::post('/updatepasscode', [LoginController::class, 'updatepasscode'])->name('updatepasscode');
Route::post('/resendforgetpasscodeemail', [LoginController::class, 'resendforgetpasscodeemail'])->name('resendforgetpasscodeemail');
Route::post('/resendforgetpasscodesms', [LoginController::class, 'resendforgetpasscodesms'])->name('resendforgetpasscodesms');





//signup
Route::get('/signup', [SignupController::class, 'signup'])->name('signup');
Route::post('signupotp', [SignupController::class,'signupotp'])->name('signupotp');

Route::middleware('signup.flow')->group(function () {

Route::get('otppage', [SignupController::class,'otppage'])->name('otppage');
Route::post('verifyotp', [SignupController::class,'verifyotp'])->name('verifyotp');
Route::get('emailsignuppage', [SignupController::class,'emailsignuppage'])->name('emailsignuppage');

Route::post('sendotponemail', [SignupController::class,'sendotponemail'])->name('sendotponemail');
Route::get('emailotppage', [SignupController::class,'emailotppage'])->name('emailotppage');
Route::post('verifyemailotp', [SignupController::class,'verifyemailotp'])->name('verifyemailotp');
Route::get('passcodepage', [SignupController::class,'passcodepage'])->name('passcodepage');
Route::post('createpasscode', [SignupController::class,'createpasscode'])->name('createpasscode');



});


Route::get('/signup/edit', [SignupController::class, 'editSignup'])->name('signup.edit');
Route::post('/resend-sms-otp', [SignupController::class, 'resendSmsOtp'])
    ->name('resend.sms.otp');
Route::get('/signup/emailedit', [SignupController::class, 'editSignupemail'])->name('signup.edit.email');
Route::post('/resend-email-otp', [SignupController::class, 'resendEmailOtp'])
    ->name('resend.email.otp');
Route::get('/auth/google', [SignupController::class, 'redirect'])
    ->name('google.redirect');

Route::get('/auth/google/callback', [SignupController::class, 'callback'])
    ->name('google.callback');

Route::get('/checkcontactinzoho', [CheckUserExistence::class, 'checkcontactinzoho'])->name('checkcontactinzoho');

//userdetails
Route::middleware('auth.user')->group(function () {

Route::get('/userdetailspage', [UserDetailsController::class, 'userdetailspage'])
    ->name('userdetailspage') ->middleware('kyc.step:0');
Route::post('/zoho/save-contact', [UserDetailsController::class, 'saveuserdetails']) ->name('zoho.contact.save');
Route::get('pancardpage', [UserDetailsController::class, 'pancardpage']) ->name('pancardpage') ->middleware('kyc.step:1');
Route::post('/kyc/pan/start', [UserDetailsController::class, 'startPanKyc'])->name('kyc.pan.start');
Route::get('aadharpage', [UserDetailsController::class, 'aadharpage']) ->name('aadharpage') ->middleware('kyc.step:2');
Route::post('/aadhaar/start', [UserDetailsController::class, 'startAadhaar'])->name('aadhaar.start');


Route::get('/aadharkycpage2', [UserDetailsController::class, 'aadharkycpage2'])->name('aadharkycpage2') ->middleware('kyc.step:3');
Route::post('/saveaadharkytwo', [UserDetailsController::class, 'saveaadharkytwo'])->name('saveaadharkytwo');
Route::get('/bankdetailpage', [UserDetailsController::class, 'bankdetailpage'])->name('bankdetailpage') ->middleware('kyc.step:4');
Route::post('/savebankdetail', [UserDetailsController::class, 'savebankdetail'])->name('savebankdetail');
Route::get('/webcampage', [UserDetailsController::class, 'webcampage'])->name('webcampage') ->middleware('kyc.step:5');
Route::post('/webcam/upload', [UserDetailsController::class, 'upload'])
    ->name('webcam.upload');
Route::get('/nomineepage', [UserDetailsController::class, 'nomineepage'])->name('nomineepage') ->middleware('kyc.step:6');
Route::post('/nominee/save', [UserDetailsController::class, 'storenomineedata'])->name('nominee.save');
Route::get('/user-detailspage', [UserDetailsController::class, 'userdetailsdata'])->name('user-detailspage') ->middleware('kyc.step:7');
Route::get('/dashboard', [DashboardController::class, 'dashboard'])->name('dashboard');
Route::get('/home_dashboard', [DashboardController::class, 'homedashboard']) ->name('home_dashboard');
Route::post('/investment/raise-request', [DashboardController::class, 'raiseRequest'])->name('investment.raise.request');
Route::get('/investmentform', [DashboardController::class, 'investmentform'])->name('investmentform');
Route::post('/sendinvestmentform', [DashboardController::class, 'investmentattachment'])->name('investment.attachment');
Route::get('/requestdashboard', [DashboardController::class, 'requestdashboard'])->name('investment.request');
Route::match(['get', 'post'],'/fetchtransactiondata', [DashboardController::class, 'fetchtransactiondata'])->name('transaction.details');
Route::get('/withdrawlform', [DashboardController::class, 'withdrawlform'])->name('withdrawlform');
Route::post('/sendwithdrawlform', [DashboardController::class, 'withdrawlattachment'])->name('withdrawl.attachment');
Route::get('/investmentwithdrawlproducts', [DashboardController::class, 'investmentwithdrawlproducts']) ->name('investmentwithdrawlproducts');
Route::post('/withdrawl/raise-request', [DashboardController::class, 'withdrawlraiseRequest'])->name('withdrawl.raise.request');
Route::get('/portal/notifications', [DashboardController::class, 'getNotifications']);
Route::post('/portal/notifications/read', [DashboardController::class, 'markAsRead']);
Route::get('/transaction-details/pdf', [DashboardController::class, 'downloadTransactionStatement'])->name('transaction.statement.pdf');
Route::match(['get', 'post'],'/logout', [UserDetailsController::class, 'logout'])->name('logout');


});
Route::match(['get', 'post'],'/store/reciept', [DashboardController::class, 'store'])->name('receipt.upload.submit');
Route::match(['get', 'post'],'/upload-receipt', [DashboardController::class, 'showUploadForm'])->name('receipt.upload.form')->middleware('signed');
Route::match(['get', 'post'],'payment/thankyou', [DashboardController::class, 'paymentthankyou'])->name('payment.thankyou');


Route::match(['get', 'post'], '/aadhaar/callback', [UserDetailsController::class, 'aadhaarCallback'])->name('aadhaar.callback');
Route::get('/digilocker/redirect', function () {return view('digilocker-redirect');});
//Route::post('/activity-ping', function () { session(['last_activity' => time()]); return response()->noContent();})->middleware('auth.user');




Route::get('/user/avatar', [UserDetailsController::class, 'avatar']) ->name('user.avatar');
Route::get('/product-photo/{productId}', [DashboardController::class, 'fetchProductPhoto'])->name('product.photo');




Route::get('/signature', function () {
    $path = storage_path('app/public/Signature.jpg');
    if (!file_exists($path)) {
        abort(404);
    }
    return response()->file($path);
})->name('show.image');











