<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>BeniSS Global - Nominee</title>
  <?php echo $__env->make('head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</head>
<body>
<?php echo $__env->make('header-user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<section class="hero-section">
  <div class="container">
    <div class="row g-4 align-items-center">
      <div class="col-lg-2"></div>
      <div class="col-lg-8">

        <!-- Stepper -->
        <div class="stepper mb-4">
          <div class="step complete">
            <div class="dot">✓</div>
            <div>PAN Verification</div>
          </div>
          <div class="line active-line"></div>

          <div class="step complete">
            <div class="dot">✓</div>
            <div>Aadhar KYC</div>
          </div>
          <div class="line active-line"></div>

          <div class="step">
            <div class="dot">✓</div>
            <div>Personal Info</div>
          </div>
          <div class="line active-line"></div>

          <div class="step">
            <div class="dot">✓</div>
            <div>Webcame</div>
          </div>
          <div class="line active-line"></div>

          <div class="step">
            <div class="dot inactive">
              <div style="background-color: #f0a100; width: 6px; height: 6px; border-radius: 50%;"></div>
            </div>
            <div class="active-text">Add Nominee</div>
          </div>
        </div>

        <div class="signup-card">

          <form class="mx-auto" action="<?php echo e(route('nominee.save')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <h3 class="text-center fw-bold mb-3">Add a nominee</h3>
            <p class="text-secondary text-center mb-4">
              You can add nominee(s) to your account. Adding nominees makes it easier to transfer ownership of your investments in case of any unfortunate eventuality.
            </p>

            <?php if($errors->any()): ?>
              <div class="alert alert-danger">
                
                  <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div> <?php echo e($error); ?></div> 
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
               
              </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
              <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
            <?php endif; ?>

            <div id="nomineeWrapper">
              <?php
                $oldNominees = old('nominees', [[]]);
              ?>

              <?php $__currentLoopData = $oldNominees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $nominee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="nominee-item position-relative">
                <h3 class="text-center fw-bold mb-3 mt-3">Nominee <?php echo e($index + 1); ?></h3>
                <button type="button" class="btn btn-sm btn-danger deleteNominee position-absolute top-0 end-0 m-2 <?php echo e($index === 0 ? 'd-none' : ''); ?>">
                  ✕
                </button>

                <div class="row g-3 mb-2">
                  <div class="col-md-12">
                    <input type="text" data-field="name" name="nominees[<?php echo e($index); ?>][name]" class="form-control" placeholder="Nominee's Name" value="<?php echo e($nominee['name'] ?? ''); ?>">
                  </div>

                  <div class="col-md-6">
                    <input type="text" data-field="pan" name="nominees[<?php echo e($index); ?>][pan]" class="form-control" placeholder="Nominee's PAN" value="<?php echo e($nominee['pan'] ?? ''); ?>">
                  </div>

                  <div class="col-md-6">
                    <input type="text" data-field="dob" name="nominees[<?php echo e($index); ?>][dob]" class="form-control" placeholder="Nominee's date of birth" onfocus="setDobMax(this)" value="<?php echo e($nominee['dob'] ?? ''); ?>">
                  </div>

                  <div class="col-md-6">
                    <input type="text" data-field="mobile" name="nominees[<?php echo e($index); ?>][mobile]" class="form-control" placeholder="Nominee's mobile" value="<?php echo e($nominee['mobile'] ?? ''); ?>">
                  </div>

                  <div class="col-md-6">
                    <input type="email" data-field="email" name="nominees[<?php echo e($index); ?>][email]" class="form-control" placeholder="Nominee's e-mail" value="<?php echo e($nominee['email'] ?? ''); ?>">
                  </div>

                  <div class="col-md-6">
                    <input type="text" data-field="relation" name="nominees[<?php echo e($index); ?>][relation]" class="form-control" placeholder="The nominee is my" value="<?php echo e($nominee['relation'] ?? ''); ?>">
                  </div>

                  <div class="col-md-6">
                    <input type="number" data-field="share" name="nominees[<?php echo e($index); ?>][share]" class="form-control" placeholder="Percentage of share(%)" value="<?php echo e($nominee['share'] ?? ''); ?>">
                  </div>

                  <div class="col-md-12">
                    <div class="p-3 border rounded">
                      <label class="form-label">Address</label>
                      <div class="d-flex gap-4">
                        <label>As per my registered address</label>
                        <label>
                          <input type="radio" data-field="same_address" name="nominees[<?php echo e($index); ?>][same_address]" value="1" <?php echo e(isset($nominee['same_address']) && $nominee['same_address'] === '1' ? 'checked' : ''); ?> > Yes
                        </label>
                        <label>
                          <input type="radio" data-field="same_address" name="nominees[<?php echo e($index); ?>][same_address]" value="0" <?php echo e(isset($nominee['same_address']) && $nominee['same_address'] === '0' ? 'checked' : ''); ?> > No
                        </label>
                      </div>
                    </div>

                    <!-- Other Address -->
                    <div class="col-md-12 other-address-container <?php echo e(isset($nominee['same_address']) && $nominee['same_address'] === '0' ? '' : 'd-none'); ?>">
<input type="text"
       data-field="other_address"
       class="form-control"
       name="nominees[<?php echo e($index); ?>][other_address]"
       placeholder="Enter nominee's address"
       value="<?php echo e($nominee['other_address'] ?? ''); ?>">
                    </div>
                    
                    
                  </div>

                </div>
                <hr>
              </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="text-center">
              <button id="addMore" type="button" class="btn btn-otp mb-2">Add Another Nominee +</button>
            </div>

            <div class="col-md-12 d-flex justify-content-center gap-4 mt-4">
              <button type="submit" class="btn btn-otp mb-2 btn-yellow">Continue</button>
            </div>

          </form>
        </div>

      </div>
    </div>
  </div>
</section>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
function setDobMax(input) {
    input.type = 'date';
    const today = new Date().toISOString().split('T')[0];
    input.max = today;
}

// Show/hide Other Address dynamically
document.addEventListener("change", function(e) {
    if (e.target.name.includes('same_address')) {
        const nomineeItem = e.target.closest(".nominee-item");
        const otherAddress = nomineeItem.querySelector(".other-address-container");

        if (e.target.value === "0") {
            otherAddress.classList.remove("d-none");
            otherAddress.querySelector("input").setAttribute("required", "required");
        } else {
            otherAddress.classList.add("d-none");
            otherAddress.querySelector("input").removeAttribute("required");
            otherAddress.querySelector("input").value = "";
        }
    }
});

// Add more nominees
let nomineeCount = document.querySelectorAll(".nominee-item").length;
document.getElementById("addMore").addEventListener("click", function () {
    const wrapper = document.getElementById("nomineeWrapper");
    const firstNominee = document.querySelector(".nominee-item");
    const clone = firstNominee.cloneNode(true);

    nomineeCount++;

   clone.querySelectorAll("input").forEach(input => {
    if (input.type === "radio" || input.type === "checkbox") {
        input.checked = false;
    } else {
        input.value = "";
    }
});

    clone.querySelector(".deleteNominee").classList.remove("d-none");

    wrapper.appendChild(clone);
    updateNomineeIndexes();
    setTimeout(() => {
    updateNomineeIndexes();
}, 0);
});

// Delete nominee
document.addEventListener("click", function (e) {
    if (e.target.classList.contains("deleteNominee")) {
        e.target.closest(".nominee-item").remove();
        updateNomineeIndexes();
    }
});

// Update indexes after cloning/deleting
function updateNomineeIndexes() {
    document.querySelectorAll(".nominee-item").forEach((item, index) => {
        item.querySelector("h3").innerText = "Nominee " + (index + 1);
        item.querySelectorAll("input").forEach(input => {
            const field = input.dataset.field;
            if (field) {
                input.name = `nominees[${index}][${field}]`;
            }
        });
        const deleteBtn = item.querySelector(".deleteNominee");
        deleteBtn.classList.toggle("d-none", index === 0);
    });

    nomineeCount = document.querySelectorAll(".nominee-item").length;
}
</script>

</body>
</html><?php /**PATH /home2/heupddmy/public_html/beniss/resources/views/nominee.blade.php ENDPATH**/ ?>