<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>BeniSS Global - Login</title>
<?php echo $__env->make('head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

</head>
<body>
<?php echo $__env->make('header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

  <section class="hero-section">
    <div class="container">
      <div class="row g-4 align-items-center">
        <div class="col-lg-6">
            <img src="<?php echo e(asset('assets/login.png')); ?>" class="img-fluid" alt="sign up"/>
        </div>

        <!-- Right side: signup form -->
         <div class="col-lg-5 ms-lg-auto">
          <div class="signup-card">
            
            <!-- Role toggle -->
            <div class="signup-tabs">
              <button type="button" class="signup-tab active">BeniSS User</button>
              <button type="button" class="signup-tab" disabled>BeniSS Partner</button>
            </div>
            <h4 class="mb-4 text-center">Login as BeniSS User</h4>

            <form action="<?php echo e(route('loginpasscode')); ?>" method="POST">
              <!-- Mobile number -->
              <?php echo csrf_field(); ?>

              <?php $__errorArgs = ['email_or_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
          <div class="text-danger mb-2">
        <?php echo e($message); ?>

         </div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              <div class="mb-3">
                <!-- <label class="form-label" for="referralCode">Referral Code</label> -->
                <input type="text" class="form-control" name="email_or_phone" id="referralCode" placeholder="Email Id / Phone Number"/>
              </div>

              

              <!-- Get OTP -->
              <button type="submit" class="btn btn-otp mb-2">
               Log in
              </button>

              <!-- OR divider -->
              <div class="divider">
                <span>or</span>
              </div>

              <!-- Already have account -->
              <p class="text-center small already-text mb-0">
                Don’t Have an Account ?
                <a href="<?php echo e(route('signup')); ?>">Sign Up</a>
              </p>
            </form>
          </div>
        </div>

      </div>
    </div>
  </section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Simple toggle for User / Partner (visual only) -->
  <script>
    const tabs = document.querySelectorAll(".signup-tab");
    tabs.forEach(tab => {
      tab.addEventListener("click", () => {
        tabs.forEach(t => t.classList.remove("active"));
        tab.classList.add("active");
        // Here you can add logic to change form fields based on selection
      });
    });
  </script>
</body>
</html>
<?php /**PATH /home2/heupddmy/public_html/beniss/resources/views/login.blade.php ENDPATH**/ ?>