<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>BeniSS Global - Sign Up</title>
 <?php echo $__env->make('head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

</head>
<body>
<?php echo $__env->make('header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

  <section class="hero-section">
    <div class="container">
      <div class="row g-4 align-items-center">
        <div class="col-lg-6">
           <img src="<?php echo e(asset('assets/sign-up.png')); ?>" class="img-fluid rounded-4" alt="sign up">

        </div>

        <!-- Right side: signup form -->
        <div class="col-lg-5 ms-lg-auto">
          <div class="signup-card">
            <h4 class="mb-4 text-center">Sign Up</h4>
            <!-- Role toggle -->
            <div class="signup-tabs">
              <button type="button" class="signup-tab active">BeniSS User</button>
              <button type="button" class="signup-tab">BeniSS Partner</button>
            </div>


            <form action="<?php echo e(route('signupotp')); ?>" method="POST">
              <?php echo csrf_field(); ?>

              <?php if($errors->any()): ?>
    <div style="color:red">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p><?php echo e($error); ?></p>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php endif; ?>

              <!-- Mobile number -->
              <div class="mb-3">
                <!-- <label class="form-label" for="mobileNumber">Mobile number</label> -->
                <div class="input-group">
                  <span class="input-group-text" style="gap: 5px;"><img class="flag" src="<?php echo e(asset('assets/flag.png')); ?>">+91</span>
                  <input type="tel" class="form-control" value="<?php echo e(old('mobile')); ?>" name="mobile" id="mobileNumber" placeholder="Mobile number" required />
                </div>
              </div>

              <!-- Referral Code -->
              <div class="mb-3">
                <!-- <label class="form-label" for="referralCode">Referral Code</label> -->
                <input type="text" class="form-control" value="<?php echo e(old('refercode')); ?>" name="referral" id="referralCode" placeholder="Referral Code"/>
              </div>

              <!-- Terms -->
              <div class="mb-3 form-check">
                <input
                  type="checkbox"
                  class="form-check-input"
                  name="privacycheck"
                  id="termsCheck" <?php echo e(old('privacycheck') ? 'checked' : ''); ?>

                />
                <label class="form-check-label small" for="termsCheck">
                  By proceeding, you agree to the
                  <a href="#" class="">BeniSS Global terms</a>
                  &
                  <a href="#" class="">privacy policy</a>.
                </label>
              </div>

              <!-- Get OTP -->
              <button type="submit" class="btn btn-otp mb-2">
                Get OTP
              </button>

              <!-- OR divider -->
              <div class="divider">
                <span>or</span>
              </div>

              <!-- Already have account -->
              <p class="text-center small already-text mb-0">
                Already have an account?
                <a href="<?php echo e(route('login')); ?>">Login</a>
              </p>
            </form>
          </div>
        </div>

      </div>
    </div>
  </section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Simple toggle for User / Partner (visual only) -->
  <script>
    const tabs = document.querySelectorAll(".signup-tab");
    tabs.forEach(tab => {
      tab.addEventListener("click", () => {
        tabs.forEach(t => t.classList.remove("active"));
        tab.classList.add("active");
        // Here you can add logic to change form fields based on selection
      });
    });
  </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\beniss\beniss\resources\views/index.blade.php ENDPATH**/ ?>