<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>PAS-4 Form</title>

    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        td {
            border: 1px solid #000;
            padding: 8px;
            vertical-align: top;
        }
        .bg-light {
            background-color: #f2f2f2;
        }
        .fw-semibold {
            font-weight: bold;
        }
        .text-center {
            text-align: center;
        }
    </style>
</head>

<body>

<table>
    <tbody>
        <tr>
            <td style="width:5%">i.</td>
            <td style="width:45%">Name</td>
            <td style="width:50%" class="bg-light"><?php echo e($name); ?></td>
        </tr>

        <tr>
            <td>ii.</td>
            <td>Father's name</td>
            <td class="bg-light"><?php echo e($father); ?></td>
        </tr>

        <tr>
            <td>iii.</td>
            <td>
                Complete Address including Flat/House Number, street, Locality, pin Code
            </td>
            <td class="bg-light" style="min-height: 90px;">
                <?php echo e($address); ?>

            </td>
        </tr>

        <tr>
            <td>iv.</td>
            <td>Phone number, if any</td>
            <td class="bg-light"><?php echo e($phone); ?></td>
        </tr>

        <tr>
            <td>v.</td>
            <td>Email ID, if any</td>
            <td class="bg-light"><?php echo e($email); ?></td>
        </tr>

        <tr>
            <td>vi.</td>
            <td>PAN Number</td>
            <td class="bg-light"><?php echo e($pan); ?></td>
        </tr>

        <tr>
            <td>vii.</td>
            <td>Bank Account Details</td>
            <td class="bg-light"><?php echo e($bank); ?></td>
        </tr>

        <tr>
            <td>viii.</td>
            <td>Security Type</td>
            <td class="bg-light"><?php echo e($security_type); ?></td>
        </tr>

        <tr>
            <td>ix.</td>
            <td colspan="2" class="fw-semibold">
                Tick whichever is applicable
            </td>
        </tr>

        <tr>
            <td>(a)</td>
            <td>
                The applicant is not required to obtain Government approval under the
                Foreign Exchange Management (Non-debt Instruments) Rules, 2019 prior to
                subscription of shares.
            </td>
            <td class="text-center">
                <?php echo e($govt_approval === 'not_required' ? '✔' : ''); ?>

            </td>
        </tr>

        <tr>
            <td>(b)</td>
            <td>
                The applicant is required to obtain Government approval under the
                Foreign Exchange Management (Non-debt Instruments) Rules, 2019 prior to
                subscription of shares and the same has been obtained, and is enclosed
                herewith.
            </td>
            <td class="text-center">
                <?php echo e($govt_approval === 'obtained' ? '✔' : ''); ?>

            </td>
        </tr>

    </tbody>
</table>

</body>
</html><?php /**PATH /home2/heupddmy/public_html/beniss/resources/views/pdf/pas4.blade.php ENDPATH**/ ?>