<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>BeniSS Global - User Details</title>
<?php echo $__env->make('head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <style>
      .signup-card{
        padding-top: 0;
      }
  </style>
</head>
<body>
    <?php if(request('from') === 'profile'): ?>
   <?php echo $__env->make('header-dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?> 
<?php else: ?>
    <?php echo $__env->make('header-user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?> 
<?php endif; ?>



  <section class="hero-section">
    <div class="container">
        <!-- Progress Bar -->
    <!--<div class="text-center mb-2 fw-semibold">20% Completed</div>-->
    <!--<div class="progress-container">-->
    <!--    <div class="progress" style="height: 6px;">-->
    <!--        <div class="progress-bar" style="width: 20%;"></div>-->
    <!--    </div>-->
    <!--</div>-->

      <div class="row g-4 mt-4">
         <div class="col-lg-4">
             <div class="leftCard">
                <div class="avatar-box" onclick="document.getElementById('avatarInputCard').click();">
                  <img id="avatarPreviewCard" src="<?php echo e(route('user.avatar')); ?>" alt="Avatar">
                    <div class="cam-icon">📷</div>

                    <!-- Hidden File Input -->
                    <input type="file" id="avatarInputCard" accept="image/*" style="display:none" onchange="previewAvatarCard(event)">
                </div>
                <p class="accId">Account ID : <?php echo $contact['Account_Id'] ?? '' ?></p>
             </div>
         </div>
      <div class="col-lg-8">
          <div class="signup-card">
         
<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul class="mb-0">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

<form action="<?php echo e(route('dashboard')); ?>" method="GET" class="mx-auto">
<?php echo csrf_field(); ?>




<div class="row g-3 mb-2">
    <div class="col-md-6">
       <input type="text" name="first_name" class="form-control"
value="<?php echo e($contact['First_Name'] ?? ''); ?>"
placeholder="First Name" readonly>
    </div>
    <div class="col-md-6">
        <input type="text" name="last_name" class="form-control"
value="<?php echo e($contact['Last_Name'] ?? ''); ?>"
placeholder="Last Name" readonly>

    </div>
</div>

<div class="mb-3">
   <input type="text" name="phone" class="form-control"
value="<?php echo e($contact['Phone'] ?? ''); ?>"
placeholder="Phone Number" readonly>

</div>

<div class="mb-3">
   <input type="email" name="email" class="form-control"
value="<?php echo e($contact['Email'] ?? ''); ?>"
placeholder="Email Id" readonly>

</div>

<div class="mb-3 p-3 border rounded">
<label class="form-label">Gender</label>
<div class="d-flex gap-4">
<label>
<input type="radio" name="gender" value="Male"
<?php echo e($contact['Gender']  == 'Male' ? 'checked' : ''); ?> disabled>
Male
</label>
<label>
<input type="radio" name="gender" value="Female"
<?php echo e($contact['Gender'] == 'Female' ? 'checked' : ''); ?> disabled>
Female
</label>
<label>
<input type="radio" name="gender" value="Other"
<?php echo e($contact['Gender']  == 'Other' ? 'checked' : ''); ?> disabled>
Other
</label>
</div>
</div>



<div class="mb-3 p-3 border rounded">
<label class="form-label">Annual Income</label>
<div class="d-flex gap-4">
<?php $__currentLoopData = ['10 Cr','25 Lacs - 1 Cr','10 - 25 Lacs','5 - 10 Lacs','1 - 5 Lacs','1 Lacs']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<label>
<input type="radio" name="income" value="<?php echo e($i); ?>"
<?php echo e($contact['Annual_Income'] == $i ? 'checked' : ''); ?> disabled>
<?php echo e($i); ?>

</label>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</div>
</div>

<div class="mb-3 p-3 border rounded">
<label class="form-label">Occupation</label>
<div class="d-flex gap-4">
<?php $__currentLoopData = ['Business','Housewife','Student','Professional','Private Sector','Others']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<label><input type="radio" name="Occupation" value="<?php echo e($o); ?>"
<?php echo e($contact['Occupation']==$o?'checked':''); ?> disabled> <?php echo e($o); ?></label>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
</div>

<div class="mb-3 p-3 border rounded">
<label class="form-label">Preference for running account settlement</label>
<div class="d-flex gap-4">
<?php $__currentLoopData = ['Monthly','Quarterly','Yearly']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<label>
<input type="radio" name="settlement" value="<?php echo e($s); ?>"
<?php echo e($contact['Preference_for_Running_Account_Settlement'] == $s ? 'checked' : ''); ?> disabled>
<?php echo e($s); ?>

</label>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


</div>
</div>





<?php
    $nominees = old('nominees', $nominees ?? []);
?>

<?php $__empty_1 = true; $__currentLoopData = $nominees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $nominee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
<h4>Nominee <?php echo e($index + 1); ?></h4>

<input type="text" class="form-control mb-2"
name="nominees[<?php echo e($index); ?>][name]"
value="<?php echo e($nominee['name'] ?? ''); ?>"
placeholder="Nominee's Name" readonly>

<div class="row g-3 mb-2">
<div class="col-md-6">
<input type="text" class="form-control"
name="nominees[<?php echo e($index); ?>][pan]"
value="<?php echo e($nominee['pan'] ?? ''); ?>"
placeholder="Nominee's PAN" readonly>
</div>

<div class="col-md-6">
<input type="date" class="form-control"
name="nominees[<?php echo e($index); ?>][dob]"
value="<?php echo e($nominee['dob'] ?? ''); ?>"
max="<?php echo e(now()->toDateString()); ?>" readonly>
</div>
</div>

<div class="row g-3 mb-2">
<div class="col-md-6">
<input type="text" class="form-control"
name="nominees[<?php echo e($index); ?>][mobile]"
value="<?php echo e($nominee['mobile'] ?? ''); ?>"
placeholder="Nominee's mobile" readonly>
</div>

<div class="col-md-6">
<input type="email" class="form-control"
name="nominees[<?php echo e($index); ?>][email]"
value="<?php echo e($nominee['email'] ?? ''); ?>"
placeholder="Nominee's e-mail" readonly>
</div>
</div>

<div class="row g-3 mb-2">
<div class="col-md-6">
<input type="text" class="form-control"
name="nominees[<?php echo e($index); ?>][relation]"
value="<?php echo e($nominee['relation'] ?? ''); ?>"
placeholder="The nominee is my" readonly>
</div>

<div class="col-md-6">
<input type="number" class="form-control"
name="nominees[<?php echo e($index); ?>][share]"
value="<?php echo e($nominee['share'] ?? ''); ?>"
placeholder="Percentage of share" readonly>
</div>
</div>

<div class="mb-3 p-3 border rounded">
<label class="form-label">Address</label>

<label>
<input type="radio"
name="nominees[<?php echo e($index); ?>][same_address]"
value="Yes"
<?php echo e(($nominee['same_address'] ?? '') == 'Yes' ? 'checked' : ''); ?> readonly>
Yes
</label>

<label>
<input type="radio"
name="nominees[<?php echo e($index); ?>][same_address]"
value="No"
<?php echo e(($nominee['same_address'] ?? '') == 'No' ? 'checked' : ''); ?> disabled>
No
</label>
</div>

<hr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>



<h4>Nominee 1</h4>

<input type="text" class="form-control mb-2" name="nominee_name"
value="<?php echo e(old('nominee_name')); ?>" placeholder="Nominee's Name" readonly>

<div class="row g-3 mb-2">
<div class="col-md-6">
<input type="text" class="form-control" name="nominee_pan"
value="<?php echo e(old('nominee_pan')); ?>" placeholder="Nominee's PAN" readonly>
</div>
<div class="col-md-6">
<input type="date" class="form-control" name="nominee_dob"
value="<?php echo e(old('nominee_dob')); ?>" readonly>
</div>
</div>

<div class="row g-3 mb-2">
<div class="col-md-6">
<input type="text" class="form-control" name="nominee_mobile"
value="<?php echo e(old('nominee_mobile')); ?>" placeholder="Nominee's mobile" readonly>
</div>
<div class="col-md-6">
<input type="text" class="form-control" name="nominee_email"
value="<?php echo e(old('nominee_email')); ?>" placeholder="Nominee's e-mail" readonly>
</div>
</div>

<div class="row g-3 mb-2">
<div class="col-md-6">
<input type="text" class="form-control" name="nominee_relation"
value="<?php echo e(old('nominee_relation')); ?>" placeholder="The nominee is my" readonly>
</div>
<div class="col-md-6">
<input type="text" class="form-control" name="nominee_percentage"
value="<?php echo e(old('nominee_percentage')); ?>" placeholder="Percentage of share" readonly>
</div>
</div>

<div class="mb-3 p-3 border rounded">
<label class="form-label">Address</label>
<label><input type="radio" name="address" value="Yes"
<?php echo e(old('address')=='Yes'?'checked':''); ?> readonly> Yes</label>
<label><input type="radio" name="address" value="No"
<?php echo e(old('address')=='No'?'checked':''); ?> readonly> No</label>
</div>

<?php endif; ?>




<div class="d-flex justify-content-center gap-4 mt-4">
<button type="submit" class="btn btn-otp mb-2 btn-yellow">Done</button>
</div>

</form>

          </div>
        </div>

      </div>
    </div>
  </section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
function previewAvatar(event) {
    const reader = new FileReader();
    reader.onload = function(){
        document.getElementById('avatarPreview').src = reader.result;
    }
    reader.readAsDataURL(event.target.files[0]);
}

function previewAvatarCard(event) {
    const reader = new FileReader();
    reader.onload = function(){
        document.getElementById('avatarPreviewCard').src = reader.result;
    }
    reader.readAsDataURL(event.target.files[0]);
}
</script>
</body>
</html>
<?php /**PATH /home2/heupddmy/public_html/beniss/resources/views/user-profile-details.blade.php ENDPATH**/ ?>