<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>BeniSS Global - Login OTP</title>
  <?php include 'head.php'; ?>

</head>
<body>
<?php include 'header-user.php'; ?>
  <section class="hero-section">
    <div class="container">
      <div class="row g-4 align-items-center">
        <div class="col-lg-2">
        </div>

        <!-- Right side: signup form -->
        <div class="col-lg-8 ">

          <div class="signup-card">
            
           <img src="images/login-otp-3.png" style="width: 100%">
            <h4 class="mb-4 text-center" style="margin: 30px 0 !important;">Link Your Bank Account</h4>

            <form action="otp.php" method="POST">

               <!-- Tabs -->
                <div class="row mb-4 g-2">
                    <div class="col-md-6">
                        <div class="custom-tab active text-center tab-btn" data-tab="upi">
                            Link with UPI 
                            <img src="https://upload.wikimedia.org/wikipedia/commons/e/e1/UPI-Logo-vector.svg" height="18">
                            <span class="ms-2">Recommended ⚡</span>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="custom-tab text-center tab-btn" data-tab="manual">
                            Enter Details Manually
                        </div>
                    </div>
                </div>

                <!-- TAB CONTENT -->
                <div id="upi" class="tab-content-box">
                    <div class="row align-items-start">
                        <div class="col-md-7 mt-5">
                            <p><strong>QR code is valid for 4:57</strong></p>
                            <p>
                                Scan this QR code with any UPI app and make a payment of ₹1.
                                This payment is just to verify your bank details and will be refunded within 24 hours.
                            </p>

                           
                        </div>

                        <div class="col-md-5 text-right">
                            <img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=Sample" alt="QR Code">
                        </div>
                    </div>
                </div>

                <div id="manual" class="tab-content-box" style="display:none;">
                    <div class="row g-3 mb-2">
                      <div class="col-md-6">
                          <input type="text" class="form-control" placeholder="IFSE">
                      </div>
                      <div class="col-md-6">
                          <input type="text" class="form-control" placeholder="Bank">
                      </div>
                  </div>

                  <div class="row g-3 mb-2">
                      <div class="col-md-6">
                          <input type="text" class="form-control" placeholder="MICR">
                      </div>
                      <div class="col-md-6">
                          <input type="text" class="form-control" placeholder="Branch">
                      </div>
                  </div>

                  <div class="row g-3 mb-2">
                      <div class="col-md-6">
                          <input type="text" class="form-control" placeholder="Account Number">
                      </div>
                      <div class="col-md-6">
                          <input type="text" class="form-control" placeholder="Confirm Account Number">
                      </div>
                  </div>
                </div>

                <!-- Buttons -->
                <div class="row mt-5">
                    <div class="col-md-6 text-start">
                        <button class="btn btn-back">Back</button>
                    </div>
                    <div class="col-md-6 text-end">
                        <button class="btn btn-continue">Continue</button>
                    </div>
                </div>
              
            

            </form>
          </div>
        </div>

      </div>
    </div>
  </section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <script>
    // Tab switch function
    const tabs = document.querySelectorAll(".tab-btn");
    const contents = document.querySelectorAll(".tab-content-box");

    tabs.forEach(tab => {
        tab.addEventListener("click", () => {

            // Remove active class from all tabs
            tabs.forEach(t => t.classList.remove("active"));

            // Add active to clicked tab
            tab.classList.add("active");

            // Hide all content boxes
            contents.forEach(c => c.style.display = "none");

            // Show selected tab content
            const target = tab.getAttribute("data-tab");
            document.getElementById(target).style.display = "block";
        });
    });
</script>
</body>
</html>
