<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>BeniSS Global - PAS-4 Form</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    @include('head')
</head>

<body>

    @include('header')

    <section class="hero-section">
        <div class="container">

            <!-- PAGE HEADING -->
            <div class="text-center my-4">
                <h5 class="fw-bold text-uppercase mb-1">FORM NO. PAS-4</h5>
                <h5 class="fw-bold text-uppercase">
                    PART-A PRIVATE PLACEMENT OFFER CUM APPLICATION LETTER
                </h5>
            </div>

            <!-- FORM CARD -->
            <div class="row justify-content-center">
                <div>
                    <div class="card shadow-sm border">
                        <div class="card-body px-4 py-3">

                            <h5 class="fw-bold text-uppercase mb-3">
                                GENERAL INFORMATION
                            </h5>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Name of Company
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $company->company_name ?? 'N/A' }}
                                </span>
                            </div>


                            <div class="d-flex  py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Address of Registered Office
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $company->registered_office_address ?? 'N/A' }}
                                </span>
                            </div>


                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Address of Corporate Office
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $company->corporate_office_address ?? 'N/A' }}
                                </span>
                            </div>


                            <div class="d-flex  py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    E-mail ID
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $company->email_id ?? 'N/A' }}
                                </span>
                            </div>


                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Website of Company
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $company->website ?? 'N/A' }}
                                </span>
                            </div>

                            <div class="d-flex  py-2">
                                <span class="text-secondary fw-medium col-4">
                                    Contact No. of Company
                                </span>
                                <span class="fw-semibold col-8">
                                    <i class="bi bi-telephone me-1"></i> {{ $company->contact_number ?? 'N/A' }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Date of Incorporation of the Company
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ optional($company->date_of_incorporation)->format('d F Y') }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Business Carried on by the Company
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $company->business_activities ?? 'N/A' }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Business carried on by its subsidiaries
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $company->branches_units_details ?? 'N/A' }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Details of branches or units, if any
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $company->branches_units_details ?? 'N/A' }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Brief particulars of the management of the company
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $company->management_brief ?? 'N/A' }}
                                </span>
                            </div>

                            <!-- MANAGEMENT / DIRECTORS TABLE (INSIDE GENERAL INFORMATION) -->
                            <div class="mt-4  py-2  border-bottom">

                                <h6 class="fw-bold text-uppercase mb-3">
                                    Details of Directors / Management
                                </h6>

                                <div class="table-responsive">
                                    <table class="table table-bordered align-middle mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th style="width: 8%;">S. No.</th>
                                                <th style="width: 22%;">Name</th>
                                                <th style="width: 30%;">Address</th>
                                                <th style="width: 20%;">DIN</th>
                                                <th style="width: 20%;">Occupation</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- SAMPLE ROW -->
                                            @forelse($companydirector->directors as $director)
                                                <tr>
                                                    <td>{{ $director->serial_no }}</td>
                                                    <td>{{ $director->name }}</td>
                                                    <td>{!! nl2br(e($director->address)) !!}</td>
                                                    <td>{{ $director->din }}</td>
                                                    <td>{{ $director->occupation }}</td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="5" class="text-center text-muted">
                                                        No director details available
                                                    </td>
                                                </tr>
                                            @endforelse

                                        </tbody>
                                    </table>
                                </div>

                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Management’s perception of risk factors:
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $company->risk_perception ?? 'N/A' }}
                                </span>
                            </div>



                            <div class="mt-4  py-2  border-bottom">
                                <div class="fw-bold text-uppercase border-bottom py-2">
                                    Details of default, if any, including therein
                                </div>


                                <div class="d-flex py-2 border-bottom">
                                    <span class="text-secondary fw-medium col-4">
                                        Amount involved
                                    </span>
                                    <span class="fw-semibold col-8">
                                        ₹ {{ number_format($default->amount_involved ?? 0, 2) }}
                                    </span>
                                </div>


                                <div class="d-flex py-2 border-bottom">
                                    <span class="text-secondary fw-medium col-4">
                                        Duration of default
                                    </span>
                                    <span class="fw-semibold col-8">
                                        {{ $default->duration_of_default ?? 'NIL' }}
                                    </span>
                                </div>


                                <div class="fw-bold border-bottom py-2">
                                    Present status in the repayment
                                </div>

                                <div class="d-flex py-2 border-bottom ps-4">
                                    <span class="text-secondary fw-medium col-4">
                                        (i) Statutory dues
                                    </span>
                                    <span class="fw-semibold col-8">
                                        {{ $default->statutory_dues_status ?? 'NIL' }}
                                    </span>
                                </div>


                                <div class="d-flex py-2 border-bottom ps-4">
                                    <span class="text-secondary fw-medium col-4">
                                        (ii) Debentures and interest thereon
                                    </span>
                                    <span class="fw-semibold col-8">
                                        {{ $default->debentures_interest_status ?? 'NIL' }}
                                    </span>
                                </div>

                                <div class="d-flex py-2 border-bottom ps-4">
                                    <span class="text-secondary fw-medium col-4">
                                        (iii) Deposits and interest thereon
                                    </span>
                                    <span class="fw-semibold col-8">
                                        {{ $default->deposits_interest_status ?? 'NIL' }}
                                    </span>
                                </div>

                                <div class="d-flex py-2 ps-4">
                                    <span class="text-secondary fw-medium col-4">
                                        (iv) Loan from any bank or financial institution and interest thereon
                                    </span>
                                    <span class="fw-semibold col-8">
                                        {{ $default->loans_interest_status ?? 'NIL' }}
                                    </span>
                                </div>

                            </div>

                            <div class="mt-4  py-2  border-bottom">
                                <div class="fw-bold border-bottom py-2">
                                    Details of the compliance/Nodal Officer of the company, if any for the Private
                                    Placement offer process
                                </div>

                                <div class="d-flex py-2 border-bottom ps-4">
                                    <span class="text-secondary fw-medium col-4">
                                        (i) Name
                                    </span>
                                    <span class="fw-semibold col-8">
                                        {{ $default->name ?? '-' }}
                                    </span>
                                </div>


                                <div class="d-flex py-2 border-bottom ps-4">
                                    <span class="text-secondary fw-medium col-4">
                                        (ii) Address
                                    </span>
                                    <span class="fw-semibold col-8">
                                        {!! nl2br(e($default->address ?? '-')) !!}
                                    </span>
                                </div>

                                <div class="d-flex py-2 border-bottom ps-4">
                                    <span class="text-secondary fw-medium col-4">
                                        (iii) Designation
                                    </span>
                                    <span class="fw-semibold col-8">
                                        {{ $default->designation ?? '-' }}
                                    </span>
                                </div>

                                <div class="d-flex py-2  border-bottom ps-4">
                                    <span class="text-secondary fw-medium col-4">
                                        (iv) Phone No.
                                    </span>
                                    <span class="fw-semibold col-8">
                                        {{ $default->phone_number ?? '-' }}
                                    </span>
                                </div>

                                <div class="d-flex py-2  ps-4">
                                    <span class="text-secondary fw-medium col-4">
                                        (iv) Email id
                                    </span>
                                    <span class="fw-semibold col-8">
                                        {{ $default->email ?? '-' }}
                                    </span>
                                </div>

                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Registrar of the Issue
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $company->registrar_of_issue ?? 'NIL' }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Valuation Agency
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $company->valuation_agency ?? 'NIL' }}
                                </span>
                            </div>


                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Auditors
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $company->auditors ?? 'NIL' }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Any Default in Annual filing of the company under the Companies Act, 2013 or the
                                    rules made thereunder
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $company->annual_filing_default ?? 'NIL' }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--//////////////////////////////////////////////////////////////////////////////////////-->
            <div class="row justify-content-center mt-4">
                <div>
                    <div class="card shadow-sm border">
                        <div class="card-body px-4 py-3">

                            <h5 class="fw-bold text-uppercase mb-3">
                                PARTICULARS OF OFFER
                            </h5>

                            <!-- Financial Position -->
                            <div class="mt-4 py-2">
                                <h6 class="fw-bold text-uppercase mb-3">
                                    Financial position of the Company for the last 3 Financial Years
                                </h6>

                                <div class="table-responsive">
                                    <table class="table table-bordered align-middle mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th style="width: 50%;">Year</th>
                                                <th style="width: 50%;">Net Profit / (Loss)</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($financialdata as $finance)
                                                <tr>
                                                    <td>{{ $finance->financial_year }}</td>
                                                    <td>
                                                        {{ number_format($finance->net_profit_loss, 2) }}
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="2" class="text-center text-muted">
                                                        No financial data available
                                                    </td>
                                                </tr>
                                            @endforelse
                                        </tbody>

                                    </table>
                                </div>
                            </div>

                            <!-- Board Resolution -->
                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Date of passing of Board Resolution
                                </span>
                                <span class="fw-semibold col-8">
                                   {{ $offer->board_resolution_date->format('d M Y') }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Date of passing of resolution in the general meeting authorizing the offer of
                                    securities
                                </span>
                                <span class="fw-semibold col-8">
                                     {{ optional($offer->general_meeting_date)->format('d M Y') ?? 'NIL' }}
                                </span>
                            </div>

                            <!-- Securities Offered -->
                            <div class="fw-bold border-bottom py-2">
                                Kinds of securities offered and the total numbers of shares or other securities to be
                                issued
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (i) Class and Kind
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->securities_class_kind }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (ii) Number of Equity Shares
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->number_of_equity_shares }}
                                </span>
                            </div>

                            <!-- Pricing Details -->
                            <div class="fw-bold border-bottom py-2">
                                Price at which the security is being offered including the premium, if any, along with
                                justification
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (i) Face Value (Rs.)
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->face_value }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (ii) Premium (Rs.)
                                </span>
                                <span class="fw-semibold col-8">
                                   {{ $offer->premium }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (iii) Issue Price (Rs.)
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->issue_price }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (iv) Justification
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->price_justification }}
                                </span>
                            </div>

                            <!-- Valuer Details -->
                            <div class="fw-bold border-bottom py-2">
                                Name and address of the valuer along with valuation report
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (i) Name
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->valuer_name }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (ii) Address
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->valuer_address }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (iii) Report of the registered valuer
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->valuer_report }}
                                </span>
                            </div>

                            <!-- Additional Details -->
                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Relevant date with reference to which the price has been arrived at
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ optional($offer->board_resolution_date)->format('d M Y') ?? 'NIL' }}

                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Class of persons to whom allotment is proposed
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->allotment_proposed_to }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Intention of promoters / directors to subscribe
                                </span>
                                <span class="fw-semibold col-8">
                                   {{ $offer->promoters_intention }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Proposed time for completion of allotment
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->proposed_allotment_time	 }}
                                </span>
                            </div>

                            <!-- Proposed Allottees -->
                            <div class="mt-4 py-2 border-bottom">
                                <h6 class="fw-bold text-uppercase mb-3">
                                    Names of proposed allottees and post placement percentage
                                </h6>

                                <div class="table-responsive">
                                    <table class="table table-bordered align-middle mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th style="width: 10%;">S. No.</th>
                                                <th style="width: 45%;">Name of Proposed Allottee</th>
                                                <th style="width: 45%;">No. of Equity Shares</th>
                                            </tr>
                                        </thead>
                                        <tbody>
@forelse($ProposedAllottes as $row)
    <tr>
        <td>{{ $row->serial_no }}</td>
        <td>{{ $row->name }}</td>
        <td>{{ number_format($row->equity_shares_count) }}</td>
        
    </tr>
@empty
    <tr>
        <td colspan="4" class="text-center text-muted">
            No shareholding data available
        </td>
    </tr>
@endforelse
</tbody>

                                    </table>
                                </div>

                                <div class="d-flex py-2">
                                    <span class="text-secondary fw-medium col-4">
                                        Percentage
                                    </span>
                                    <span class="fw-semibold col-8">
                                        NIL
                                    </span>
                                </div>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    The change in control, if any, in the company that would occur consequent to the
                                    private placement
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->control_change_details }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    The number of persons to whom allotment on preferential basis/private
                                    placement/rights issue has already been made during the year, in terms of number of
                                    securities as well as price
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->previous_allotments_details }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    The justification for the allotment proposed to be made for consideration other than
                                    cash together with valuation report of the registered valuer
                                </span>
                                <span class="fw-semibold col-8">
                                   {{ $offer->non_cash_allotment_justification }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Amount which the company intends to raise by way of proposed offer of securities
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->amount_to_raise }}
                                </span>
                            </div>

                            <div class="fw-bold border-bottom py-2">
                                Terms of raising of securities - Duration, if applicable, rate of dividend or rate of
                                interest, mode of payment and repayment
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (i) Type of Security
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->security_type }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (ii) Duration, if applicable
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->duration }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (iii) Divident
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->dividend }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (iv) Rate of Interest
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->interest_rate }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (v) Mode of Payment and Repayment
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->payment_repayment_mode }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Proposed time schedule for which the private placement offer cum application letter
                                    is valid
                                </span>
                                <span class="fw-semibold col-8">
                                     {{ $offer->offer_validity_period }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Purposes and objects the offer
                                </span>
                                <span class="fw-semibold col-8">
                                     {{ $offer->offer_purpose }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Contribution being made by the promoters or directors either as part of the offer or
                                    separately in furtherance of such objects
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->promoters_contribution }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Principle terms of assets charged as security, if applicable
                                </span>
                                <span class="fw-semibold col-8">
                                    {{ $offer->assets_security_terms }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    The details of significant and material orders passed by the Regulators, Courts and
                                    Tribunals impacting the going concern status of the company and its future
                                    operations
                                </span>
                                <span class="fw-semibold col-8">
                                   {{ $offer->regulatory_orders_details }}
                                </span>
                            </div>

                            <div class="fw-bold border-bottom py-2">
                                The pre-issue and post-issue shareholding pattern of the company
                            </div>

                            <div class="table-responsive mt-4">
                                <table class="table table-bordered text-center align-middle">
                                    <thead>
                                        <tr>
                                            <th rowspan="2" style="width: 6%;">S. No</th>
                                            <th rowspan="2" style="width: 24%;">Category</th>
                                            <th colspan="2" style="width: 35%;">Pre-issue</th>
                                            <th colspan="2" style="width: 35%;">Post-issue</th>
                                        </tr>
                                        <tr>
                                            <th>No. of shares held</th>
                                            <th>% of share holding</th>
                                            <th>No. of shares held</th>
                                            <th>% of shares holding</th>
                                        </tr>
                                    </thead>

                                    <!--<tbody>-->
                                        <!-- A. Promoters' Holding -->
                                    <!--    <tr class="fw-bold text-start">-->
                                    <!--        <td>A</td>-->
                                    <!--        <td>Promoters’ holding</td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--    </tr>-->

                                    <!--    <tr class="text-start">-->
                                    <!--        <td>1</td>-->
                                    <!--        <td>Indian</td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--    </tr>-->

                                    <!--    <tr class="text-start">-->
                                    <!--        <td></td>-->
                                    <!--        <td class="ps-4">Individual</td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--    </tr>-->

                                    <!--    <tr class="text-start">-->
                                    <!--        <td></td>-->
                                    <!--        <td class="ps-4">Bodies Corporate</td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--    </tr>-->

                                    <!--    <tr class="text-start">-->
                                    <!--        <td></td>-->
                                    <!--        <td class="ps-4">Sub-total</td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--    </tr>-->

                                    <!--    <tr class="text-start">-->
                                    <!--        <td>2</td>-->
                                    <!--        <td>Foreign promoters</td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--    </tr>-->

                                    <!--    <tr class="fw-bold text-start">-->
                                    <!--        <td></td>-->
                                    <!--        <td>Sub-total (A)</td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--    </tr>-->

                                        <!-- B. Non-Promoters' Holding -->
                                    <!--    <tr class="fw-bold text-start">-->
                                    <!--        <td>B</td>-->
                                    <!--        <td>Non-promoters’ holding</td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--    </tr>-->

                                    <!--    <tr class="text-start">-->
                                    <!--        <td>1</td>-->
                                    <!--        <td>Institutional investors</td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--    </tr>-->

                                    <!--    <tr class="text-start">-->
                                    <!--        <td>2</td>-->
                                    <!--        <td>Non-institutional investors</td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--    </tr>-->

                                    <!--    <tr class="text-start">-->
                                    <!--        <td></td>-->
                                    <!--        <td>Private corporate bodies</td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--    </tr>-->

                                    <!--    <tr class="text-start">-->
                                    <!--        <td></td>-->
                                    <!--        <td>Director and relatives</td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--    </tr>-->

                                    <!--    <tr class="text-start">-->
                                    <!--        <td></td>-->
                                    <!--        <td>Indian public</td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--    </tr>-->

                                    <!--    <tr class="text-start">-->
                                    <!--        <td></td>-->
                                    <!--        <td>-->
                                    <!--            Others <br>-->
                                    <!--            <small>(including Non-resident Indians (NRIs))</small>-->
                                    <!--        </td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--    </tr>-->

                                    <!--    <tr class="fw-bold text-start">-->
                                    <!--        <td></td>-->
                                    <!--        <td>Sub-total (B)</td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--    </tr>-->

                                        <!-- Grand Total -->
                                    <!--    <tr class="fw-bold">-->
                                    <!--        <td></td>-->
                                    <!--        <td class="text-start">GRAND TOTAL (A+B)</td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--        <td></td>-->
                                    <!--    </tr>-->
                                    <!--</tbody>-->
                                    
                                    <tbody>
@php
    $groupedData = $shareholdingpatterns
        ->sortBy('category_order')
        ->groupBy('category');
@endphp

@foreach($groupedData as $category => $rows)
    {{-- Category Header --}}
    <tr class="fw-bold text-start">
        <td>{{ $loop->iteration == 1 ? 'A' : 'B' }}</td>
        <td>{{ $category }}</td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>

    @foreach($rows as $row)
        <tr class="text-start">
            <td></td>
            <td class="{{ $row->sub_category ? 'ps-4' : '' }}">
                {{ $row->sub_category }}
            </td>
            <td>{{ $row->pre_issue_shares }}</td>
            <td>{{ $row->pre_issue_percentage }}%</td>
            <td>{{ $row->post_issue_shares }}</td>
            <td>{{ $row->post_issue_percentage }}%</td>
        </tr>
    @endforeach

    {{-- Sub-total --}}
    <tr class="fw-bold text-start">
        <td></td>
        <td>Sub-total ({{ $loop->iteration == 1 ? 'A' : 'B' }})</td>
        <td>{{ $rows->sum('pre_issue_shares') }}</td>
        <td>{{ number_format($rows->sum('pre_issue_percentage'), 2) }}%</td>
        <td>{{ $rows->sum('post_issue_shares') }}</td>
        <td>{{ number_format($rows->sum('post_issue_percentage'), 2) }}%</td>
    </tr>
@endforeach

{{-- Grand Total --}}
<tr class="fw-bold">
    <td></td>
    <td class="text-start">GRAND TOTAL (A+B)</td>
    <td>{{ $shareholdingpatterns->sum('pre_issue_shares') }}</td>
    <td>{{ number_format($shareholdingpatterns->sum('pre_issue_percentage'), 2) }}%</td>
    <td>{{ $shareholdingpatterns->sum('post_issue_shares') }}</td>
    <td>{{ number_format($shareholdingpatterns->sum('post_issue_percentage'), 2) }}%</td>
</tr>
</tbody>

                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <!--///////////////////////////////////////////////////////////////////////////////////-->
            <div class="row justify-content-center mt-4">
                <div>
                    <div class="card shadow-sm border">
                        <div class="card-body px-4 py-3">
                            <h5 class="fw-bold text-uppercase mb-3">
                                MODE OF PAYMENT FOR SUBSCRIPTION
                            </h5>
                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    a. Cheque
                                </span>
                                <span class="fw-semibold col-8">
                                    {{$PaymentMode->cheque_mode }}
                                </span>
                            </div>
                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Demand Draft
                                </span>
                                <span class="fw-semibold col-8">
                                    {{$PaymentMode->demand_draft_mode }}
                                </span>
                            </div>
                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    c. Other Banking Channels
                                </span>
                                <span class="fw-semibold col-8">
                                    {{$PaymentMode->other_banking_channels }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!--///////////////////////////////////////////////////////////////////////////////////-->
            <div class="row justify-content-center mt-4">
                <div>
                    <div class="card shadow-sm border">
                        <div class="card-body px-4 py-3">
                            <h5 class="fw-bold text-uppercase mb-3">
                                DISCLOSURES WITH REGARD TO INTEREST OF DIRECTORS, LITIGATION, ETC.
                            </h5>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Any financial or other material interest of the directors, promoters or key
                                    managerial personnel in the offer and the effect of such interest in so far as it is
                                    different from the interests of other persons
                                </span>
                                <span class="fw-semibold col-8">
                                    {{$Disclosures->directors_interest_details }}
                                </span>
                            </div>
                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Details of any litigation or legal action pending or taken by any Ministry or
                                    Department of the Government or a statutory authority against any promoter of the
                                    offeree company during the last three years immediately preceding the year of the
                                    issue of the private placement offer cum application letter and any direction issued
                                    by such Ministry or Department or statutory authority upon conclusion of such
                                    litigation or legal action shall be disclosed
                                </span>
                                <span class="fw-semibold col-8">
                                    {{$Disclosures->litigation_details }}
                                </span>
                            </div>

                            <div class="mt-4  py-2  border-bottom">

                                <h6 class="fw-bold text-uppercase mb-3">
                                    Remuneration of directors (during the current year and last three financial years)
                                </h6>

                                <div class="table-responsive">
                                    <table class="table table-bordered align-middle mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th style="width: 25%;">Name of the Directors</th>
                                                <th style="width: 25%;">Year end 31-Mar23</th>
                                                <th style="width: 25%;">Year end 31-Mar24</th>
                                                <th style="width: 25%;">Year end 31-Mar25</th>
                                            </tr>
                                        </thead>
                            <tbody>
                        @forelse($CompanyDirectorRemuneration as $director)
                            <tr>
                                <td>{{ $director->director_name }}</td>
                                <td>{{ number_format($director->year_2023 ?? 0, 2) }}</td>
                                <td>{{ number_format($director->year_2024 ?? 0, 2) }}</td>
                                <td>{{ number_format($director->year_2025 ?? 0, 2) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center text-muted">
                                    No director remuneration data available
                                </td>
                            </tr>
                        @endforelse
                        </tbody>

                                    </table>
                                </div>

                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Related party transactions entered during the last three financial years immediately
                                    preceding the year of issue of private placement offer cum application letter
                                    including with regard to loans made or, guarantees given or securities provided
                                </span>
                                <span class="fw-semibold col-8">
                                    {{$Disclosures->related_party_transactions }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Summary of reservations or qualifications or adverse remarks of auditors in the last
                                    five
                                    financial years immediately preceding the year of issue of private placement offer
                                    cum
                                    application letter and of their impact on the financial statements and financial
                                    position
                                    of the company and the corrective steps taken and proposed to be taken by the
                                    company
                                    for each of the said reservations or qualifications or adverse remark
                                </span>
                                <span class="fw-semibold col-8">
                                    {{$Disclosures->auditors_remarks }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Details of any inquiry, inspections or investigations initiated or conducted under
                                    the
                                    Companies Act, 2013 or any previous company raw in the last three years immediately
                                    preceding the year of issue of private placement offer cum application letter in the
                                    case
                                    of company and all of its subsidiaries, and if there were any prosecutions filed
                                    (whether
                                    pending or not), fines imposed, compounding of offences in the last three years
                                    immediately preceding the year of the private placement offer cum application letter
                                    and if so, section-wise details thereof for the company and all of its subsidiaries
                                </span>
                                <span class="fw-semibold col-8">
                                    {{$Disclosures->inquiries_investigations }}
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Details of acts of material frauds committed against the company in the last three
                                    years,
                                    if any, and if so, the action taken by the company
                                </span>
                                <span class="fw-semibold col-8">
                                    {{$Disclosures->material_frauds }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!--///////////////////////////////////////////////////////////////////////////////////-->
            <div class="row justify-content-center mt-4">
                <div>
                    <div class="card shadow-sm border">
                        <div class="card-body px-4 py-3">
                            <h5 class="fw-bold text-uppercase mb-3">
                                FINANCIAL POSITION OF THE COMPANY
                            </h5>

                            <div class="mt-4  py-2  border-bottom">

                                <h6 class="fw-bold text-uppercase mb-3">
                                    The capital structure of the company
                                </h6>

                                <div class="table-responsive">
                                    <table class="table table-bordered align-middle mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th style="width: 40%;"></th>
                                                <th style="width: 15%;">Authorised Capital (In Rs.) </th>
                                                <th style="width: 15%;">Issued Capital (In Rs.) </th>
                                                <th style="width: 15%;">Subscribed Capital (In Rs.)</th>
                                                <th style="width: 15%;">Paid Up Capital(In Rs.) </th>
                                            </tr>
                                        </thead>
                                       <tbody>
                            @forelse($CapitalStructure as $row)
                                <tr>
                                    <td>{{ $row->category }}</td>
                            
                                    <td>
                                        {{ number_format($row->authorized_capital ?? 0, 2) }}
                                    </td>
                            
                                    <td>
                                        {{ number_format($row->issued_capital ?? 0, 2) }}
                                    </td>
                            
                                    <td>
                                        {{ number_format($row->subscribed_capital ?? 0, 2) }}
                                    </td>
                            
                                    <td>
                                        {{ number_format($row->paid_up_capital ?? 0, 2) }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center text-muted">
                                        No capital structure data available
                                    </td>
                                </tr>
                            @endforelse
                            </tbody>
                                    </table>
                                </div>

                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Size of the present offer
                                </span>
                                <span class="fw-semibold col-8">
                                    NA
                                </span>
                            </div>

                            <div class="fw-bold border-bottom py-2">
                                Paid up capital
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (i) After the offer
                                </span>
                                <span class="fw-semibold col-8">
                                    NIL
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (ii) After conversion of convertible instruments (if applicable)
                                </span>
                                <span class="fw-semibold col-8">
                                    NIL
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom ps-4">
                                <span class="text-secondary fw-medium col-4">
                                    (iii) Share premium account (before and after the offer)
                                </span>
                                <span class="fw-semibold col-8">
                                    NIL
                                </span>
                            </div>


                            <div class="mt-4  py-2  border-bottom">

                                <h6 class="fw-bold text-uppercase mb-3">
                                    Details of the existing share capital of the issuer company
                                </h6>

                                <div class="table-responsive">
                                    <table class="table table-bordered align-middle mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th style="width: 40%;">Details</th>
                                                <th style="width: 10%;">Date of Allotment</th>
                                                <th style="width: 10%;">Number of Equity Shares</th>
                                                <th style="width: 10%;">Face Value</th>
                                                <th style="width: 10%;">Premium</th>
                                                <th style="width: 10%;">Total</th>
                                                <th style="width: 10%;">Form of Consideration</th>
                                            </tr>
                                        </thead>
                                       <tbody>
                        @php
                            $totalShares = 0;
                            $totalFaceValue = 0;
                            $totalPremium = 0;
                            $totalAmount = 0;
                        @endphp
                        
                        @forelse($ExistingShareCapital as $row)
                            @php
                                $totalShares += $row->number_of_equity_shares ?? 0;
                                $totalFaceValue += ($row->face_value ?? 0);
                                $totalPremium += ($row->premium ?? 0);
                                $totalAmount += ($row->total_amount ?? 0);
                            @endphp
                        
                            <tr>
                                <td>{{ $row->details }}</td>
                        
                                <td>
                                    {{ $row->date_of_allotment
                                        ? \Carbon\Carbon::parse($row->date_of_allotment)->format('d-m-Y')
                                        : '-' }}
                                </td>
                        
                                <td>{{ number_format($row->number_of_equity_shares ?? 0) }}</td>
                                <td>{{ number_format($row->face_value ?? 0, 2) }}</td>
                                <td>{{ number_format($row->premium ?? 0, 2) }}</td>
                                <td>{{ number_format($row->total_amount ?? 0, 2) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center text-muted">
                                    No existing share capital data available
                                </td>
                            </tr>
                        @endforelse
                        
                        {{-- TOTAL ROW --}}
                        @if($ExistingShareCapital->count())
                        <tr class="fw-bold">
                            <td>Total</td>
                            <td>-</td>
                            <td>{{ number_format($totalShares) }}</td>
                            <td>{{ number_format($totalFaceValue, 2) }}</td>
                            <td>{{ number_format($totalPremium, 2) }}</td>
                            <td>{{ number_format($totalAmount, 2) }}</td>
                        </tr>
                        @endif
                        </tbody>

                                    </table>
                                </div>

                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    The number and price at which each of the allotments were made in the last one year
                                    preceding the date of the private placement offer cum application letter
                                </span>
                                <span class="fw-semibold col-8">
                                    NA
                                </span>
                            </div>

                            <div class="mt-4  py-2  border-bottom">

                                <h6 class="fw-bold text-uppercase mb-3">
                                    Profits of the company, before and after making provision for tax, for the three
                                    financial years immediately preceding the date of issue of private placement offer
                                    cum application letter
                                </h6>

                                <div class="table-responsive">
                                    <table class="table table-bordered align-middle mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th style="width: 50%;">Particulars</th>
                                                <th style="width: 50%;">(Amount in INR)</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                            @forelse($ProfitTaxProvision as $row)
                                {{-- Financial Year Header --}}
                                <tr>
                                    <td class="fw-bold">FY {{ $row->financial_year }}</td>
                                    <td></td>
                                </tr>
                            
                                {{-- Profit before tax --}}
                                <tr>
                                    <td>Profit/(Loss) before provisions for taxation</td>
                                    <td>
                                        {{ number_format($row->profit_before_tax ?? 0, 2) }}
                                    </td>
                                </tr>
                            
                                {{-- Profit after tax --}}
                                <tr>
                                    <td>Profit/(Loss) after provisions for taxation</td>
                                    <td>
                                        {{ number_format($row->profit_after_tax ?? 0, 2) }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="2" class="text-center text-muted">
                                        No profit/loss data available
                                    </td>
                                </tr>
                            @endforelse
                            </tbody>

                                    </table>
                                </div>

                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Dividends declared by the company in respect of the said three financial years;
                                    interest coverage ratio for last three years (cash profit after tax plus interest
                                    paid/interest paid)
                                </span>
                                <span class="fw-semibold col-8">
                                    NA
                                </span>
                            </div>

                            <div class="mt-4  py-2  border-bottom">

                                <h6 class="fw-bold text-uppercase mb-3">
                                    A summary of the financial position of the company as in the three audited balance
                                    sheets immediately preceding the date of issue of private placement offer cum
                                    application letter:
                                </h6>

                                <div class="table-responsive">
                                    <table class="table table-bordered align-middle mb-0">
                                        <thead class="table-light">
                                <tr>
                                    <th style="width:40%">Particulars</th>
                                    @foreach($FinancialSummary as $row)
                                        <th style="width:20%">
                                            Figures for the Financial Year ended {{$row->financial_year }}
                                        </th>
                                    @endforeach
                                </tr>
                                </thead>

                                       <tbody>
                                <tr class="fw-bold">
                                    <td>Total Revenue</td>
                                    @foreach($FinancialSummary as $row)
                                        <td>{{ number_format($row->total_revenue ?? 0, 2) }}</td>
                                    @endforeach
                                </tr>
                                
                                <tr>
                                    <td>Profit/(Loss) before taxation</td>
                                    @foreach($FinancialSummary as $row)
                                        <td>{{ number_format($row->profit_before_tax ?? 0, 2) }}</td>
                                    @endforeach
                                </tr>
                                
                                <tr>
                                    <td>Less: Tax Expense</td>
                                    @foreach($FinancialSummary as $row)
                                        <td>{{ number_format($row->tax_expense ?? 0, 2) }}</td>
                                    @endforeach
                                </tr>
                                
                                <tr>
                                    <td>Profit/Loss after tax</td>
                                    @foreach($FinancialSummary as $row)
                                        <td>{{ number_format($row->profit_after_tax ?? 0, 2) }}</td>
                                    @endforeach
                                </tr>
                                
                                <tr>
                                    <td>Add: Balance B/F from the previous year</td>
                                    @foreach($FinancialSummary as $row)
                                        <td>{{ number_format($row->balance_brought_forward ?? 0, 2) }}</td>
                                    @endforeach
                                </tr>
                                
                                <tr>
                                    <td>Surplus/(Deficit) carried forward to Balance sheet</td>
                                    @foreach($FinancialSummary as $row)
                                        <td>{{ number_format($row->surplus_deficit ?? 0, 2) }}</td>
                                    @endforeach
                                </tr>
                                </tbody>

                                    </table>
                                </div>

                            </div>


                            <div class="table-responsive mt-4">
                                <h6 class="fw-bold text-uppercase mb-3">
                                    Audited Cash Flow statement for the three years immediately preceding the date of
                                    issue of private placement offer cum application lette
                                </h6>

                                <table class="table table-bordered table-sm align-middle">
                                    <thead class="table-light text-center">
                                        <tr>
                                            <th class="text-start">Particulars</th>
                                            <th>FY-2025</th>
                                            <th>FY-2024</th>
                                            <th>FY-2023</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        <!-- OPERATING ACTIVITIES -->
                                        <tr class="table-secondary fw-bold">
                                            <td colspan="4">Cash flow from operating activities</td>
                                        </tr>

                                        <tr>
                                            <td>Profit / (Loss) before tax</td>
                                            <td class="text-end">87.94</td>
                                            <td class="text-end">(35.67)</td>
                                            <td class="text-end">23.01</td>
                                        </tr>

                                        <tr>
                                            <td>Adjustments for:</td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>

                                        <tr>
                                            <td class="ps-4">Depreciation</td>
                                            <td class="text-end">4.50</td>
                                            <td class="text-end">6.58</td>
                                            <td class="text-end">9.68</td>
                                        </tr>

                                        <tr>
                                            <td class="ps-4">Assets Written Off</td>
                                            <td class="text-end">-</td>
                                            <td class="text-end">-</td>
                                            <td class="text-end">-</td>
                                        </tr>

                                        <tr>
                                            <td class="ps-4">Income Tax Adjustment</td>
                                            <td class="text-end">-</td>
                                            <td class="text-end">(0.10)</td>
                                            <td class="text-end">-</td>
                                        </tr>

                                        <tr class="fw-bold table-secondary">
                                            <td>Operating profit before working capital changes</td>
                                            <td class="text-end">92.44</td>
                                            <td class="text-end">(29.19)</td>
                                            <td class="text-end">32.69</td>
                                        </tr>

                                        <tr>
                                            <td>(Increase) / Decrease in trade and other receivables</td>
                                            <td class="text-end">9.73</td>
                                            <td class="text-end">1.22</td>
                                            <td class="text-end">7.57</td>
                                        </tr>

                                        <tr>
                                            <td>(Increase) / Decrease in inventories</td>
                                            <td class="text-end">(15.88)</td>
                                            <td class="text-end">0.21</td>
                                            <td class="text-end">(0.48)</td>
                                        </tr>

                                        <tr>
                                            <td>Increase / (Decrease) in other current liabilities</td>
                                            <td class="text-end">148.00</td>
                                            <td class="text-end">(0.81)</td>
                                            <td class="text-end">(0.79)</td>
                                        </tr>

                                        <tr>
                                            <td>Increase / (Decrease) in short term borrowings</td>
                                            <td class="text-end">1317.71</td>
                                            <td class="text-end">-</td>
                                            <td class="text-end">2.03</td>
                                        </tr>

                                        <tr>
                                            <td>Increase / (Decrease) in trade payables</td>
                                            <td class="text-end">3.89</td>
                                            <td class="text-end">-</td>
                                            <td class="text-end">(11.70)</td>
                                        </tr>

                                        <tr>
                                            <td>Cash generated from operations</td>
                                            <td class="text-end">1573.61</td>
                                            <td class="text-end">(30.81)</td>
                                            <td class="text-end">30.20</td>
                                        </tr>

                                        <tr class="fw-bold table-secondary">
                                            <td>Net cash flow (used in) operating activities (A)</td>
                                            <td class="text-end">1556.55</td>
                                            <td class="text-end">(30.81)</td>
                                            <td class="text-end">27.92</td>
                                        </tr>

                                        <!-- INVESTING ACTIVITIES -->
                                        <tr class="table-secondary fw-bold">
                                            <td colspan="4">Cash flows from investing activities</td>
                                        </tr>

                                        <tr>
                                            <td>Purchase of property, plant & equipment</td>
                                            <td class="text-end">(0.69)</td>
                                            <td class="text-end">-</td>
                                            <td class="text-end">-</td>
                                        </tr>

                                        <tr>
                                            <td>Investment income</td>
                                            <td class="text-end">16.55</td>
                                            <td class="text-end">(14.91)</td>
                                            <td class="text-end">-</td>
                                        </tr>

                                        <tr class="fw-bold table-secondary">
                                            <td>Net cash flow (used in) investing activities (B)</td>
                                            <td class="text-end">(1414.12)</td>
                                            <td class="text-end">23.23</td>
                                            <td class="text-end">13.05</td>
                                        </tr>

                                        <!-- FINANCING ACTIVITIES -->
                                        <tr class="table-secondary fw-bold">
                                            <td colspan="4">Cash flows from financing activities</td>
                                        </tr>

                                        <tr>
                                            <td>Payment of long-term borrowings</td>
                                            <td class="text-end">(7.15)</td>
                                            <td class="text-end">0.71</td>
                                            <td class="text-end">-</td>
                                        </tr>

                                        <tr class="fw-bold table-secondary">
                                            <td>Net cash generated from financing activities (C)</td>
                                            <td class="text-end">(7.15)</td>
                                            <td class="text-end">0.71</td>
                                            <td class="text-end">-</td>
                                        </tr>

                                        <!-- TOTAL -->
                                        <tr class="fw-bold">
                                            <td>Net increase / (decrease) in cash and cash equivalents (A+B+C)</td>
                                            <td class="text-end">151.14</td>
                                            <td class="text-end">(21.78)</td>
                                            <td class="text-end">40.97</td>
                                        </tr>

                                        <tr>
                                            <td>Cash and cash equivalents at the beginning of the year</td>
                                            <td class="text-end">28.99</td>
                                            <td class="text-end">50.77</td>
                                            <td class="text-end">9.79</td>
                                        </tr>

                                        <tr class="fw-bold">
                                            <td>Cash and cash equivalents at the end of the year</td>
                                            <td class="text-end">180.13</td>
                                            <td class="text-end">28.99</td>
                                            <td class="text-end">50.77</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium col-4">
                                    Any change in accounting policies during the last three years and their effect on
                                    the profits and the reserves of the company
                                </span>
                                <span class="fw-semibold col-8">
                                    NA
                                </span>
                            </div>












                        </div>
                    </div>
                </div>
            </div>

            <!-- ////////////////////////////////////////////////////////////////////////////////-->

            <!-- PAGE HEADING -->
            <div class="text-center my-4">
                <h5 class="fw-bold text-uppercase mb-1">PART-B</h5>
                <h5 class="fw-bold text-uppercase">
                    (To be filled by the Applicant)
                </h5>
            </div>
            <!-- ////////////////////////////////////////////////////////////////////////-->
            <div class="row justify-content-center mt-4">
                <div>
                    <div class="card shadow-sm border">
                        <div class="card-body px-4 py-3">

                            <div class="table-responsive mt-4">
                                <table class="table table-bordered align-middle">
                                    <tbody>
                                        <tr>
                                            <td style="width:5%">i.</td>
                                            <td style="width:45%">Name</td>
                                            <td style="width:50%">
                                                <input type="text" class="form-control" />
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>ii.</td>
                                            <td>Father's name</td>
                                            <td>
                                                <input type="text" class="form-control" />
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>iii.</td>
                                            <td>
                                                Complete Address including Flat/House Number, street, Locality, pin Code
                                            </td>
                                            <td>
                                                <textarea class="form-control" rows="3"></textarea>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>iv.</td>
                                            <td>Phone number, if any</td>
                                            <td>
                                                <input type="tel" class="form-control" />
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>v.</td>
                                            <td>Email ID, if any</td>
                                            <td>
                                                <input type="email" class="form-control" />
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>vi.</td>
                                            <td>PAN Number</td>
                                            <td>
                                                <input type="text" class="form-control" />
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>vii.</td>
                                            <td>Bank Account Details</td>
                                            <td>
                                                <input type="text" class="form-control" />
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>viii.</td>
                                            <td colspan="2" class="fw-semibold">
                                                Tick whichever is applicable
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>(a)</td>
                                            <td>
                                                The applicant is not required to obtain Government approval under the
                                                Foreign Exchange Management (Non-debt Instruments) Rules, 2019 prior to
                                                subscription of shares.
                                            </td>
                                            <td class="text-center">
                                                <input class="form-check-input" type="checkbox" checked />
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>(b)</td>
                                            <td>
                                                The applicant is required to obtain Government approval under the
                                                Foreign Exchange Management (Non-debt Instruments) Rules, 2019 prior to
                                                subscription of shares and the same has been obtained, and is enclosed
                                                herewith.
                                            </td>
                                            <td class="text-center">
                                                <input class="form-check-input" type="checkbox" checked />
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <div class="container mt-4">
                                <div class="mb-2 fw-semibold">Signature</div>

                                <div class="border p-3 rounded">
                                    <input type="file" class="form-control" accept="image/png, image/jpeg" />
                                    <small class="text-muted">
                                        Upload e-signature (PNG / JPG only)
                                    </small>
                                </div>

                                <p class="mt-3">
                                    Initial of the Officer of the company designated to keep the record
                                </p>
                            </div>

                            <!--<div class="container mt-4">
                            <div class="mb-3 fw-semibold">Signature</div>

                            <div class="border p-3 rounded">
                                <canvas id="signaturePad" width="600" height="150"></canvas>

                                <div class="mt-2 d-flex gap-2">
                                <button class="btn btn-sm btn-secondary" onclick="clearSignature()">
                                    Clear
                                </button>
                                <button class="btn btn-sm btn-primary" onclick="saveSignature()">
                                    Save Signature
                                </button>
                                </div>
                            </div>

                            <p class="mt-3">
                                Initial of the Officer of the company designated to keep the record
                            </p>

                            <input type="hidden" id="signatureData" name="signature">
                        </div> -->

                        </div>

                    </div>
                </div>
            </div>

            <!-- ////////////////////////////////////////////////////////////////////////-->
            <div class="row justify-content-center mt-4">
                <div>
                    <div class="card shadow-sm border">
                        <div class="card-body px-4 py-3">
                            <h5 class="fw-bold text-uppercase mb-3">
                                A DECLARATION BY THE DIRECTORS THAT
                            </h5>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium">
                                    a. The company has complied with the provisions of the Companies Act, 2013 and the
                                    rules made there under;
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium">
                                    b. The compliance with the said Act and the rules made thereunder do not imply that
                                    payment of dividend or interest or repayment of preference shares or debentures, if
                                    applicable, is guaranteed by the Central Government; and
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium">
                                    c. The monies received under the offer shall be used only for the purposes and
                                    objects indicated in the private placement offer cum application letter;
                                </span>
                            </div>

                            <div class="d-flex py-2 border-bottom">
                                <span class="text-secondary fw-medium">
                                    I am authorised by the Board of Directors of the company vide resolution number
                                    <input type="text" class="form-control d-inline-block mx-1"
                                        style="width: 160px; height: 28px;" placeholder="Resolution No." />
                                    dated
                                    <input type="date" class="form-control d-inline-block mx-1"
                                        style="width: 160px; height: 28px;" />
                                    to sign this form and declare that all the requirements of the Companies Act, 2013
                                    and
                                    the rules made thereunder in respect of the subject matter of this form and matters
                                    incidental thereto have been complied with. Whatever is stated in this form and the
                                    attachments thereto is true, correct and complete and no information material to the
                                    subject matter of this form has been suppressed or concealed and is as per the
                                    original
                                    records maintained by the promoters subscribing to the Memorandum of Association and
                                    Articles of Association. It is further declared and verified that all the required
                                    attachments have been completely, correctly and legibly attached to this form.
                                </span>
                            </div>

                            <div class="d-flex justify-content-between py-2 border-bottom align-items-center">

                                <span class="fw-semibold  col-5">
                                    Date:
                                    <input type="date" class="form-control d-inline-block ms-2" />
                                </span>

                                <span class="fw-semibold col-5">
                                    Place:
                                    <input type="text" class="form-control d-inline-block ms-2"
                                        placeholder="Enter place" />
                                </span>

                            </div>

                        </div>
                    </div>
                </div>

            </div>
    </section>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js">
        const fileInput = document.querySelector('input[type="file"]');
        const preview = document.getElementById("signPreview");

        fileInput.addEventListener("change", function () {
            const file = this.files[0];

            if (file) {
                preview.src = URL.createObjectURL(file);
                preview.classList.remove("d-none");
            }
        });

    </script>

</body>

</html>